<?php

namespace VM\AdminBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\AdminBundle\Services\ApiGetter;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyReport;
use VM\ApiBundle\Entity\Round;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;
use VM\FinancialStatementsBundle\Services\FinancialStatementGame;
use VM\FinancialStatementsBundle\Services\Reports\SimpleReport;

class RoundsController extends AbstractController
{
    /**
     * @View(serializerGroups={"manage"})
     */
    public function listAction()
    {
        /** @var User $User */
        $User = $this->getUser();
        $Groups = $User->getAdminGroups();

        /** @var UserGroups $Group */
        foreach($Groups as $Group)
        {
            $rounds = $Group->getRounds();

            if(count($rounds) == 0)
            {
                for($i = 1; $i <= 8; $i++)
                {
                    $Round = new Round();
                    $Round->setName('Tura ' . $i);
                    $Round->setGroup($Group);
                    $Round->setSequence($i);

                    $this->getDoctrine()->getManager()->persist($Round);
                    $Group->addRound($Round);
                    $this->getDoctrine()->getManager()->persist($Group);
                }
                $this->getDoctrine()->getManager()->flush();
                $this->getDoctrine()->getManager()->clear();
            }
        }

        $User = $this->getUser();
        $Groups = $User->getAdminGroups();

        return $Groups;
    }


    /**
     * @View(serializerGroups={"manage"})
     */
    public function saveAction()
    {
        $groupData = $this->getRequest()->request->getIterator()->getArrayCopy();
        $ApiGetter = $this->getApiGetter();
//
//        echo "<pre>";
//        print_r($groupData);

        $Group = $ApiGetter->getGroup($groupData['id']);
        foreach($groupData['rounds'] as $round)
        {
            $Round = $ApiGetter->getRound($round['id']);
            if(!empty($round['start_at']))
            {
                $Round->setStartAt(\DateTime::createFromFormat("Y-m-d H:i:s", $round['start_at']));
            }
            else
            {
                $Round->setStartAt(null);
            }
        }

        $this->getDoctrine()->getManager()->flush();
        $this->getDoctrine()->getManager()->clear();

        return $groupData;
    }

    /**
     * @View(serializerGroups={"manage"})
     */
    public function endRoundAction($groupId)
    {
        $ApiGetter = $this->getApiGetter();
        $Group = $ApiGetter->getGroup($groupId);
        $CurrentRound = $this->getApiGetter()->getGroupActualRound($Group);
        $CurrentRound->setIsCounting(true);
        $this->getDoctrine()->getManager()->flush();

        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            if(!$this->getApiGetter()->isTeacher($this->getUser()))
            {
                throw new \Exception('You are not allowed to end round');
            }

            $EndRound = $this->get('vm_admin.end_round');

            /** @var Round $PrevRound */
            $PrevRound = $EndRound->getPreviousRound($CurrentRound);
            if($PrevRound !== false && !$PrevRound->getIsDone())
            {
                throw new \Exception('Poprzednia runda nie została zakończona');
            }

            $EndRound->endRound($CurrentRound);

            $CurrentRound->setIsCounting(false);
            $CurrentRound->setIsDone(true);

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();

            return array('success' => true);
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            $CurrentRound->setIsCounting(false);
            throw $Exception;
            $this->getDoctrine()->getManager()->flush();
            return array('success' => false, 'error' => array('message' => $Exception->getMessage(), 'code' => $Exception->getCode()));
        }
    }
}
